/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.quick;

import edu.neu.ccs.quick.QuickTreeSet;
import edu.neu.ccs.quick.QuickVector;

public final class StringSet {
    private QuickTreeSet stringSet = new QuickTreeSet();
    private QuickVector stringList = new QuickVector();

    public StringSet() {
    }

    public StringSet(String[] strings) {
        this.addStrings(strings);
    }

    public void addString(String string) {
        if (string == null) {
            return;
        }
        if (this.contains(string)) {
            return;
        }
        this.stringSet.add(string);
        this.stringList.add(string);
    }

    public void addStrings(String[] strings) {
        if (strings == null) {
            return;
        }
        int length = strings.length;
        int i = 0;
        while (i < length) {
            this.addString(strings[i]);
            ++i;
        }
    }

    public void setStrings(String[] strings) {
        this.clear();
        this.addStrings(strings);
    }

    public String remove(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        String string = this.getString(index);
        this.stringSet.remove(string);
        this.stringList.remove(index);
        return string;
    }

    public String remove(String string) {
        if (!this.contains(string)) {
            return null;
        }
        this.stringSet.remove(string);
        this.stringList.remove(string);
        return string;
    }

    public void clear() {
        this.stringSet.clear();
        this.stringList.clear();
    }

    public int size() {
        return this.stringList.size();
    }

    public String getString(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return (String)this.stringList.get(index);
    }

    public String[] getStrings() {
        return this.stringList.toArray(new String[0]);
    }

    public String[] getSortedStrings() {
        return this.stringSet.toArray(new String[0]);
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        return this.stringSet.contains(string);
    }
}

