/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.quick;

import java.util.Hashtable;
import java.util.Map;

public class QuickHashtable
extends Hashtable {
    public QuickHashtable() {
    }

    public QuickHashtable(int initialCapacity) {
        super(initialCapacity);
    }

    public QuickHashtable(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public QuickHashtable(Map m) {
        super(m);
    }

    public QuickHashtable(Object[][] pairs) {
        super(pairs == null ? 10 : Math.max((int)(1.5 * (double)pairs.length), 10));
        this.putPairs(pairs);
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            return null;
        }
        return super.put(key, value);
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return super.get(key);
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        return super.remove(key);
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        return super.containsValue(value);
    }

    public boolean contains(Object value) {
        if (value == null) {
            return false;
        }
        return super.contains(value);
    }

    public void putPairs(Object[][] pairs) {
        if (pairs == null) {
            return;
        }
        int length = pairs.length;
        int i = 0;
        while (i < length) {
            if (pairs[i] != null && pairs[i].length == 2 && pairs[i][0] != null && pairs[i][1] != null) {
                this.put(pairs[i][0], pairs[i][1]);
            }
            ++i;
        }
    }

    public void setPairs(Object[][] pairs) {
        this.clear();
        this.putPairs(pairs);
    }

    public void removeKeys(Object[] keys) {
        if (keys == null) {
            return;
        }
        int length = keys.length;
        int i = 0;
        while (i < length) {
            if (keys[i] != null) {
                this.remove(keys[i]);
            }
            ++i;
        }
    }

    public void putSymmetric(Object key, Object value) {
        if (key == null || value == null) {
            return;
        }
        this.put(key, value);
        this.put(value, key);
    }

    public void putPairsSymmetric(Object[][] pairs) {
        if (pairs == null) {
            return;
        }
        int length = pairs.length;
        int i = 0;
        while (i < length) {
            if (pairs[i] != null && pairs[i].length == 2) {
                this.putSymmetric(pairs[i][0], pairs[i][1]);
            }
            ++i;
        }
    }

    public void setPairsSymmetric(Object[][] pairs) {
        this.clear();
        this.putPairsSymmetric(pairs);
    }
}

