/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.quick;

import java.util.HashMap;
import java.util.Map;

public class QuickHashMap
extends HashMap {
    public QuickHashMap() {
    }

    public QuickHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public QuickHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public QuickHashMap(Map m) {
        super(m);
    }

    public QuickHashMap(Object[][] pairs) {
        super(pairs == null ? 10 : Math.max((int)(1.5 * (double)pairs.length), 10));
        this.putPairs(pairs);
    }

    public void putPairs(Object[][] pairs) {
        if (pairs == null) {
            return;
        }
        int length = pairs.length;
        int i = 0;
        while (i < length) {
            if (pairs[i] != null && pairs[i].length == 2) {
                this.put(pairs[i][0], pairs[i][1]);
            }
            ++i;
        }
    }

    public void setPairs(Object[][] pairs) {
        this.clear();
        this.putPairs(pairs);
    }

    public void removeKeys(Object[] keys) {
        if (keys == null) {
            return;
        }
        int length = keys.length;
        int i = 0;
        while (i < length) {
            this.remove(keys[i]);
            ++i;
        }
    }

    public void putSymmetric(Object key, Object value) {
        this.put(key, value);
        this.put(value, key);
    }

    public void putPairsSymmetric(Object[][] pairs) {
        if (pairs == null) {
            return;
        }
        int length = pairs.length;
        int i = 0;
        while (i < length) {
            if (pairs[i] != null && pairs[i].length == 2) {
                this.putSymmetric(pairs[i][0], pairs[i][1]);
            }
            ++i;
        }
    }

    public void setPairsSymmetric(Object[][] pairs) {
        this.clear();
        this.putPairsSymmetric(pairs);
    }
}

