/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pedagogy;

import edu.neu.ccs.gui.BufferedPanel;
import edu.neu.ccs.gui.DisplayWrapper;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.PlotTool;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class Turtle {
    public static final int MINIMUM_SIZE = 201;
    public static final int PREFERRED_SIZE = 401;
    public static final Paint DEFAULT_PAINT = Color.black;
    public static final int PEN_UP = 0;
    public static final int PEN_DOWN = 1;
    private static final double DEGREES_TO_RADIANS = Math.PI / 180;
    protected static BufferedPanel turtleBufferPanel = null;
    protected static int turtleBufferPanelSize = 401;
    protected static AffineTransform transform = null;
    protected static Vector turtleList = new Vector();
    protected double xPosition = 0.0;
    protected double yPosition = 0.0;
    protected double direction = 0.0;
    protected Paint penPaint = DEFAULT_PAINT;
    protected int penState = 1;
    protected boolean showTurtle = true;
    protected boolean autoRepaint = true;
    private Line2D line = new Line2D.Double();
    private Point2D point1 = new Point2D.Double();
    private Point2D point2 = new Point2D.Double();
    GeneralPath path = new GeneralPath(1, 4);

    public static void setTurtleBufferPanelSize(int n) {
        if (turtleBufferPanel == null) {
            if (n < 201) {
                n = 201;
            }
            turtleBufferPanelSize = n;
        }
    }

    public static int getTurtleBufferPanelSize() {
        return turtleBufferPanelSize;
    }

    public static BufferedPanel getTurtleBufferPanel() {
        if (turtleBufferPanel == null) {
            turtleBufferPanel = new 1(turtleBufferPanelSize, turtleBufferPanelSize);
            Turtle.useCenterCoordinates();
        }
        return turtleBufferPanel;
    }

    public static void useCenterCoordinates() {
        if (turtleBufferPanel != null) {
            int n = (turtleBufferPanelSize + 1) / 2;
            transform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, n, n);
        }
    }

    public static void useCornerCoordinates() {
        if (turtleBufferPanel != null) {
            boolean bl = false;
            int n = turtleBufferPanelSize - 1;
            transform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, (float)bl, n);
        }
    }

    public static void setCoordinatesViaBounds(Rectangle2D rectangle2D) {
        Turtle.setCoordinatesViaBounds(rectangle2D, 0);
    }

    public static void setCoordinatesViaBounds(Rectangle2D rectangle2D, int n) {
        if (turtleBufferPanel != null && rectangle2D != null) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, turtleBufferPanelSize, turtleBufferPanelSize);
            PlotTool plotTool = new PlotTool(rectangle2D, double_, true, n);
            transform = plotTool.getTransform();
        }
    }

    public static Graphics2D getTurtleBufferGraphics() {
        return Turtle.getTurtleBufferPanel().getBufferGraphics();
    }

    public static BufferedImage getTurtleBuffer() {
        return Turtle.getTurtleBufferPanel().getBuffer();
    }

    public static void clear() {
        Turtle.getTurtleBufferPanel().clearPanel();
        Turtle.repaint();
    }

    public static void repaint() {
        Turtle.getTurtleBufferPanel().repaint();
    }

    public static Turtle[] getTurtles() {
        int n = turtleList.size();
        Turtle[] turtleArray = new Turtle[n];
        int n2 = 0;
        while (n2 < n) {
            turtleArray[n2] = (Turtle)turtleList.get(n2);
            ++n2;
        }
        return turtleArray;
    }

    public static void showAllTurtles() {
        Turtle[] turtleArray = Turtle.getTurtles();
        int n = turtleArray.length;
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            turtleArray[n2].showTurtle = true;
            ++n2;
        }
        Turtle.repaint();
    }

    public static void hideAllTurtles() {
        Turtle[] turtleArray = Turtle.getTurtles();
        int n = turtleArray.length;
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            turtleArray[n2].showTurtle = false;
            ++n2;
        }
        Turtle.repaint();
    }

    public Turtle() {
        Turtle.getTurtleBufferPanel();
        turtleList.add(this);
    }

    public void step(double d) {
        double d2 = Math.cos(this.direction * (Math.PI / 180));
        double d3 = Math.sin(this.direction * (Math.PI / 180));
        double d4 = d * d2;
        double d5 = d * d3;
        if (this.penState == 1) {
            this.point1.setLocation(this.xPosition, this.yPosition);
            this.xPosition += d4;
            this.yPosition += d5;
            this.point2.setLocation(this.xPosition, this.yPosition);
            transform.transform(this.point1, this.point1);
            transform.transform(this.point2, this.point2);
            this.line.setLine(this.point1, this.point2);
            Graphics2D graphics2D = Turtle.getTurtleBufferGraphics();
            graphics2D.setPaint(this.penPaint != null ? this.penPaint : DEFAULT_PAINT);
            graphics2D.draw(this.line);
        } else {
            this.xPosition += d4;
            this.yPosition += d5;
        }
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public void turn(double d) {
        this.setDirection(this.direction + d);
    }

    public void showTurtle() {
        this.showTurtle = true;
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public void hideTurtle() {
        this.showTurtle = false;
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public void setVisible(boolean bl) {
        this.showTurtle = bl;
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public boolean isVisible() {
        return this.showTurtle;
    }

    public void setPosition(double d, double d2) {
        this.xPosition = d;
        this.yPosition = d2;
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public void setPosition(Point2D point2D) {
        if (point2D != null) {
            this.setPosition(point2D.getX(), point2D.getY());
        }
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.xPosition, this.yPosition);
    }

    public double getX() {
        return this.xPosition;
    }

    public double getY() {
        return this.yPosition;
    }

    public void setDirection(double d) {
        if ((d %= 360.0) < 0.0) {
            d += 360.0;
        }
        this.direction = d;
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public double getDirection() {
        return this.direction;
    }

    public void setPaint(Paint paint) {
        this.penPaint = paint;
        if (this.autoRepaint) {
            Turtle.repaint();
        }
    }

    public void setPaint(int n, int n2, int n3) {
        this.setPaint(new Color(n, n2, n3));
    }

    public void setPaint(int n, int n2, int n3, int n4) {
        this.setPaint(new Color(n, n2, n3, n4));
    }

    public Paint getPaint() {
        return this.penPaint;
    }

    public void setPenState(int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.penState = n;
                break;
            }
        }
    }

    public int getPenState() {
        return this.penState;
    }

    public void setAutoRepaint(boolean bl) {
        this.autoRepaint = bl;
    }

    public boolean getAutoRepaint() {
        return this.autoRepaint;
    }

    public void reset() {
        this.xPosition = 0.0;
        this.yPosition = 0.0;
        this.direction = 0.0;
        this.penPaint = DEFAULT_PAINT;
        this.penState = 1;
        this.autoRepaint = true;
        this.showTurtle = true;
        Turtle.repaint();
    }

    protected void drawTurtle(Graphics2D graphics2D) {
        this.point1.setLocation(this.xPosition, this.yPosition);
        transform.transform(this.point1, this.point1);
        float f = (float)this.point1.getX();
        float f2 = (float)this.point1.getY();
        float f3 = (float)Math.cos(this.direction * (Math.PI / 180));
        float f4 = (float)Math.sin(this.direction * (Math.PI / 180));
        float f5 = 6.0f;
        float f6 = 4.0f;
        this.path.reset();
        this.path.moveTo(f + f5 * f3, f2 - f5 * f4);
        this.path.lineTo(f - f5 * f3 - f6 * f4, f2 + f5 * f4 - f6 * f3);
        this.path.lineTo(f - f5 * f3 + f6 * f4, f2 + f5 * f4 + f6 * f3);
        this.path.closePath();
        graphics2D.setPaint(this.penPaint != null ? this.penPaint : DEFAULT_PAINT);
        graphics2D.fill(this.path);
    }

    public static void selfTest() {
        Turtle.setTurtleBufferPanelSize(501);
        JPTFrame.createQuickJPTFrame("Turtle Self Test", new DisplayWrapper(Turtle.getTurtleBufferPanel()));
        int n = 96;
        int n2 = Turtle.getTurtleBufferPanelSize() / 4;
        Turtle turtle = new Turtle();
        int n3 = 1;
        while (n3 <= n) {
            turtle.step(n3);
            turtle.turn(90.0);
            ++n3;
        }
        Turtle turtle2 = new Turtle();
        turtle2.setPosition(n2, n2);
        turtle2.setPaint(Color.blue);
        int n4 = 1;
        while (n4 <= n) {
            turtle2.step(n4);
            turtle2.turn(60.0);
            ++n4;
        }
        Turtle.useCornerCoordinates();
        Turtle turtle3 = new Turtle();
        turtle3.setPosition(n2, n2);
        turtle3.setAutoRepaint(false);
        Color[] colorArray = new Color[]{Color.black, Color.red, Color.green, Color.blue, Color.magenta, Color.yellow};
        int n5 = 1;
        while (n5 <= n) {
            turtle3.setPaint(colorArray[n5 % 6]);
            turtle3.step(n5);
            turtle3.turn(60.0);
            ++n5;
        }
        Turtle.repaint();
        Rectangle2D.Double double_ = new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0);
        Turtle.setCoordinatesViaBounds(double_);
        Turtle turtle4 = new Turtle();
        turtle4.setPosition(0.5, -0.5);
        turtle4.setPaint(153, 51, 0);
        double d = Turtle.getTurtleBufferPanelSize() / 2;
        int n6 = 1;
        while (n6 <= n) {
            turtle4.step((double)n6 / d);
            turtle4.turn(90.0);
            ++n6;
        }
        Turtle.useCenterCoordinates();
        Turtle[] turtleArray = Turtle.getTurtles();
        int n7 = turtleArray.length;
        int n8 = 0;
        while (n8 < n7) {
            turtleArray[n8].setAutoRepaint(true);
            turtleArray[n8].setPosition(-n2, n2);
            turtleArray[n8].setDirection(90 * n8 + 15);
            turtleArray[n8].setPaint(colorArray[n8]);
            turtleArray[n8].step(n2 / 2);
            ++n8;
        }
    }

    private final class 1
    extends BufferedPanel {
        public void paintOver(Graphics2D graphics2D) {
            Turtle[] turtleArray = Turtle.getTurtles();
            int n = turtleArray.length;
            if (n == 0) {
                return;
            }
            int n2 = 0;
            while (n2 < n) {
                if (turtleArray[n2].showTurtle) {
                    turtleArray[n2].drawTurtle(graphics2D);
                }
                ++n2;
            }
        }

        /* synthetic */ 1(int n, int n2) {
            super(n, n2);
        }
    }
}

