/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.jpf;

import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.PaintAction;
import edu.neu.ccs.gui.PaintActionCapsule;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.jpf.JPFApplication;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.JPTError;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.border.EmptyBorder;

public class JPFBase
implements JPTConstants {
    private static final PaintAction CHECK_ACTION = new 1();
    private static final PaintAction X_ACTION = new 2();

    protected boolean declaresMethod(Class clazz, String string) {
        return this.hasConstructorsAndMethods(clazz, null, new String[]{string}, false, true);
    }

    protected boolean declaresMethodNoDialog(Class clazz, String string) {
        return this.hasConstructorsAndMethods(clazz, null, new String[]{string}, false, false);
    }

    protected boolean providesMethod(Class clazz, String string) {
        return this.hasConstructorsAndMethods(clazz, null, new String[]{string}, true, true);
    }

    protected boolean providesMethodNoDialog(Class clazz, String string) {
        return this.hasConstructorsAndMethods(clazz, null, new String[]{string}, true, false);
    }

    protected boolean declaresMethods(Class clazz, String[] stringArray) {
        return this.hasConstructorsAndMethods(clazz, null, stringArray, false, true);
    }

    protected boolean declaresMethodsNoDialog(Class clazz, String[] stringArray) {
        return this.hasConstructorsAndMethods(clazz, null, stringArray, false, false);
    }

    protected boolean providesMethods(Class clazz, String[] stringArray) {
        return this.hasConstructorsAndMethods(clazz, null, stringArray, true, true);
    }

    protected boolean providesMethodsNoDialog(Class clazz, String[] stringArray) {
        return this.hasConstructorsAndMethods(clazz, null, stringArray, true, false);
    }

    protected boolean declaresConstructor(Class clazz, String string) {
        return this.hasConstructorsAndMethods(clazz, new String[]{string}, null, false, true);
    }

    protected boolean declaresConstructorNoDialog(Class clazz, String string) {
        return this.hasConstructorsAndMethods(clazz, new String[]{string}, null, false, false);
    }

    protected boolean declaresConstructors(Class clazz, String[] stringArray) {
        return this.hasConstructorsAndMethods(clazz, stringArray, null, false, true);
    }

    protected boolean declaresConstructorsNoDialog(Class clazz, String[] stringArray) {
        return this.hasConstructorsAndMethods(clazz, stringArray, null, false, false);
    }

    protected boolean declaresConstructorsAndMethods(Class clazz, String[] stringArray, String[] stringArray2) {
        return this.hasConstructorsAndMethods(clazz, stringArray, stringArray2, false, true);
    }

    protected boolean declaresConstructorsAndMethodsNoDialog(Class clazz, String[] stringArray, String[] stringArray2) {
        return this.hasConstructorsAndMethods(clazz, stringArray, stringArray2, false, false);
    }

    protected boolean providesConstructorsAndMethods(Class clazz, String[] stringArray, String[] stringArray2) {
        return this.hasConstructorsAndMethods(clazz, stringArray, stringArray2, true, true);
    }

    protected boolean providesConstructorsAndMethodsNoDialog(Class clazz, String[] stringArray, String[] stringArray2) {
        return this.hasConstructorsAndMethods(clazz, stringArray, stringArray2, true, false);
    }

    protected void report(Class clazz, String[] stringArray, boolean[] blArray, String[] stringArray2, boolean[] blArray2) {
        TablePanel tablePanel = new TablePanel(stringArray.length + stringArray2.length, 2, 20, 5, 7);
        PaintAction paintAction = null;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            paintAction = blArray[n2] ? CHECK_ACTION : X_ACTION;
            tablePanel.addObject((Object)new PaintActionCapsule((Action)paintAction, 10, 15), n, 0);
            tablePanel.addObject((Object)new Annotation(stringArray[n2]), n, 1);
            ++n;
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray2.length) {
            paintAction = blArray2[n3] ? CHECK_ACTION : X_ACTION;
            tablePanel.addObject((Object)new PaintActionCapsule((Action)paintAction, 10, 15), n, 0);
            tablePanel.addObject((Object)new Annotation(stringArray2[n3]), n, 1);
            ++n;
            ++n3;
        }
        String string = "";
        if (stringArray.length > 0 && stringArray2.length > 0) {
            string = "constructors and methods";
        } else if (stringArray.length > 0) {
            string = "constructors";
        } else if (stringArray2.length > 0) {
            string = "methods";
        }
        TablePanel tablePanel2 = new TablePanel(new Object[]{"The following " + string + " are required\n" + "in class " + JPFApplication.className(clazz) + ":", tablePanel}, 1, 0, 10, 1);
        tablePanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        GeneralDialog.showOKDialog(tablePanel2, "Required " + string);
    }

    private boolean hasConstructorsAndMethods(Class clazz, String[] stringArray, String[] stringArray2, boolean bl, boolean bl2) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        boolean[] blArray = new boolean[stringArray.length];
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        boolean[] blArray2 = new boolean[stringArray2.length];
        boolean bl3 = true;
        int n = 0;
        while (n < stringArray.length) {
            blArray[n] = this.hasConstructorImpl(clazz, stringArray[n]);
            if (!blArray[n]) {
                bl3 = false;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            blArray2[n2] = this.hasMethodImpl(clazz, stringArray2[n2], bl);
            if (!blArray2[n2]) {
                bl3 = false;
            }
            ++n2;
        }
        if (!bl3 && bl2) {
            this.report(clazz, stringArray, blArray, stringArray2, blArray2);
        }
        return bl3;
    }

    private boolean hasMethodImpl(Class clazz, String string, boolean bl) {
        if (clazz == null) {
            return false;
        }
        MethodSignature methodSignature = new MethodSignature(string);
        try {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = 0;
            while (n < methodArray.length) {
                if (methodSignature.equals(methodArray[n])) {
                    return true;
                }
                ++n;
            }
            if (bl) {
                return this.hasMethodImpl(clazz.getSuperclass(), string, true);
            }
            return false;
        }
        catch (SecurityException securityException) {
            return true;
        }
    }

    private boolean hasConstructorImpl(Class clazz, String string) {
        if (clazz == null) {
            return false;
        }
        ConstructorSignature constructorSignature = new ConstructorSignature(string);
        try {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            int n = 0;
            while (n < constructorArray.length) {
                if (constructorSignature.equals(constructorArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        catch (SecurityException securityException) {
            return true;
        }
    }

    private final class 1
    extends PaintAction {
        private Stroke stroke = new BasicStroke(2.0f);

        public void paint(Component component, Graphics graphics) {
            int n = component.getWidth() / 3;
            int n2 = component.getHeight() / 2;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(this.stroke);
            graphics2D.setColor(new Color(0, 128, 0));
            graphics2D.draw(new Line2D.Double(0.0, n2, n, component.getHeight() - 1));
            graphics2D.draw(new Line2D.Double(n, component.getHeight() - 1, n2 + 1, 0.0));
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends PaintAction {
        private Stroke stroke = new BasicStroke(2.0f);

        public void paint(Component component, Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(this.stroke);
            graphics2D.setColor(Color.red);
            graphics2D.draw(new Line2D.Double(0.0, 0.0, component.getWidth() - 1, component.getHeight() - 1));
            graphics2D.draw(new Line2D.Double(component.getWidth() - 1, 0.0, 0.0, component.getHeight() - 1));
        }

        /* synthetic */ 2() {
        }
    }

    private static abstract class MemberSignature {
        protected int modifiers = 0;
        protected String name = null;

        protected abstract void fromString(String var1) throws JPTError;

        protected void addModifier(String string) {
            int n = 0;
            if (string.equals("public")) {
                n = 1;
            } else if (string.equals("protected")) {
                n = 4;
            } else if (string.equals("private")) {
                n = 2;
            } else if (string.equals("abstract")) {
                n = 1024;
            } else if (string.equals("static")) {
                n = 8;
            } else if (string.equals("final")) {
                n = 16;
            } else if (string.equals("synchronized")) {
                n = 32;
            }
            this.modifiers |= n;
        }

        protected boolean isModifier(String string) {
            return string.equals("public") || string.equals("protected") || string.equals("private") || string.equals("abstract") || string.equals("static") || string.equals("final") || string.equals("synchronized");
        }

        protected String className(Class clazz) {
            String string = clazz.getName();
            int n = string.lastIndexOf(".");
            if (n < 0) {
                return string;
            }
            return string.substring(n + 1);
        }

        protected String modifierString() {
            String string = "";
            if (Modifier.isPublic(this.modifiers)) {
                string = String.valueOf(string) + "public ";
            }
            if (Modifier.isProtected(this.modifiers)) {
                string = String.valueOf(string) + "protected ";
            }
            if (Modifier.isPrivate(this.modifiers)) {
                string = String.valueOf(string) + "private ";
            }
            if (Modifier.isAbstract(this.modifiers)) {
                string = String.valueOf(string) + "abstract ";
            }
            if (Modifier.isStatic(this.modifiers)) {
                string = String.valueOf(string) + "static ";
            }
            if (Modifier.isFinal(this.modifiers)) {
                string = String.valueOf(string) + "final ";
            }
            if (Modifier.isSynchronized(this.modifiers)) {
                string = String.valueOf(string) + "synchronized ";
            }
            return string;
        }

        MemberSignature() {
        }
    }

    private static abstract class ParametrizedSignature
    extends MemberSignature {
        private ArrayList parameters = new ArrayList();
        private ArrayList parameterNames = new ArrayList();

        protected void addParameter(String string, String string2) {
            this.parameters.add(string);
            this.parameterNames.add(string2);
        }

        public String[] getParameterTypes() {
            return this.parameters.toArray(new String[0]);
        }

        public String[] getParameterNames() {
            return this.parameterNames.toArray(new String[0]);
        }

        protected String parameterString() {
            String string = "(";
            String[] stringArray = this.getParameterTypes();
            String[] stringArray2 = this.getParameterNames();
            if (stringArray.length > 0) {
                string = String.valueOf(string) + stringArray[0] + " " + stringArray2[0];
                int n = 1;
                while (n < stringArray.length) {
                    string = String.valueOf(string) + "," + stringArray[n] + " " + stringArray[n];
                    ++n;
                }
            }
            string = String.valueOf(string) + ")";
            return string;
        }

        ParametrizedSignature() {
        }
    }

    private static class MethodSignature
    extends ParametrizedSignature {
        protected String returnType = null;

        public MethodSignature(String string) throws JPTError {
            this.fromString(string);
        }

        protected void fromString(String string) throws JPTError {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            try {
                String string2 = stringTokenizer.nextToken();
                while (this.isModifier(string2)) {
                    this.addModifier(string2);
                    string2 = stringTokenizer.nextToken();
                }
                this.returnType = string2;
                this.name = stringTokenizer.nextToken("(,) ");
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    this.addParameter(string2, string3);
                }
            }
            catch (Exception exception) {
                throw new JPTError("Method signature malformed: " + string);
            }
        }

        public String toString() {
            String string = "";
            string = String.valueOf(string) + this.modifierString();
            string = String.valueOf(string) + this.returnType + " " + this.name;
            string = String.valueOf(string) + this.parameterString();
            return string;
        }

        public boolean equals(Method method) {
            String[] stringArray;
            if (method.getModifiers() != this.modifiers) {
                return false;
            }
            if (!method.getName().equals(this.name)) {
                return false;
            }
            if (!this.className(method.getReturnType()).equals(this.returnType)) {
                return false;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != (stringArray = this.getParameterTypes()).length) {
                return false;
            }
            int n = 0;
            while (n < classArray.length) {
                if (!this.className(classArray[n]).equals(stringArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    private static class ConstructorSignature
    extends ParametrizedSignature {
        public ConstructorSignature(String string) throws JPTError {
            this.fromString(string);
        }

        protected void fromString(String string) throws JPTError {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            try {
                String string2;
                String string3 = stringTokenizer.nextToken();
                if (this.isModifier(string3)) {
                    this.addModifier(string3);
                }
                this.name = string2 = stringTokenizer.nextToken("(,) ");
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    this.addParameter(string3, string2);
                }
            }
            catch (Exception exception) {
                throw new JPTError("Constructor signature malformed: " + string);
            }
        }

        public String toString() {
            String string = "";
            string = String.valueOf(string) + this.modifierString();
            string = String.valueOf(string) + this.name;
            string = String.valueOf(string) + this.parameterString();
            return string;
        }

        public boolean equals(Constructor constructor) {
            String[] stringArray;
            if (constructor.getModifiers() != this.modifiers) {
                return false;
            }
            if (!constructor.getName().equals(this.name)) {
                return false;
            }
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != (stringArray = this.getParameterTypes()).length) {
                return false;
            }
            int n = 0;
            while (n < classArray.length) {
                if (!this.className(classArray[n]).equals(stringArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        protected boolean isModifier(String string) {
            return string.equals("public") || string.equals("protected") || string.equals("private");
        }
    }
}

