/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.BaseShape;
import edu.neu.ccs.gui.ClosureMode;
import edu.neu.ccs.gui.Path;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.FloatArray;

public class TweakableShape
extends BaseShape {
    public static final String SET_VERTEX_DATA = "set.vertex.data";
    public static final String SET_TANGENT_DATA = "set.tangent.data";
    public static final String SET_VERTEX_TANGENT_DATA = "set.vertex.tangent.data";
    public static final String SET_VERTEX = "set.vertex";
    public static final String SET_TANGENT = "set.tangent";
    public static final String SET_VERTEX_TANGENT = "set.vertex.tangent";
    public static final String ADD_VERTEX_TANGENT = "add.vertex.tangent";
    public static final String REMOVE_VERTEX_TANGENT = "remove.vertex.tangent";

    public TweakableShape() {
        this(null, null, null, null, null);
    }

    public TweakableShape(float[][] fArray) {
        this(fArray, null, null, null, null);
    }

    public TweakableShape(float[][] fArray, float[][] fArray2) {
        this(fArray, fArray2, null, null, null);
    }

    public TweakableShape(float[][] fArray, float[][] fArray2, Path.Strategy strategy) {
        this(fArray, fArray2, strategy, null, null);
    }

    public TweakableShape(float[][] fArray, float[][] fArray2, Path.Strategy strategy, ClosureMode closureMode) {
        this(fArray, fArray2, strategy, closureMode, null);
    }

    public TweakableShape(float[][] fArray, float[][] fArray2, Path.Strategy strategy, ClosureMode closureMode, WindingRule windingRule) {
        this.setPathStrategy(strategy);
        this.setClosureMode(closureMode);
        this.setWindingRule(windingRule);
        this.setVertexTangentData(fArray, fArray2);
    }

    public final void setVertexData(float[][] fArray) {
        if (!FloatArray.checkArray(fArray, 2) || fArray.length != this.tangent.length) {
            return;
        }
        if (FloatArray.equals(this.vertex, fArray)) {
            return;
        }
        this.vertex = FloatArray.deepclone(fArray);
        this.makePath();
        this.firePropertyChange(SET_VERTEX_DATA, null, null);
    }

    public final void setTangentData(float[][] fArray) {
        if (fArray == null) {
            fArray = new float[this.vertex.length][2];
        } else if (!FloatArray.checkArray(fArray, 2) || fArray.length != this.vertex.length) {
            return;
        }
        if (FloatArray.equals(this.tangent, fArray)) {
            return;
        }
        this.tangent = FloatArray.deepclone(fArray);
        this.makePath();
        this.firePropertyChange(SET_TANGENT_DATA, null, null);
    }

    public final void setVertexTangentData(float[][] fArray, float[][] fArray2) {
        if (!FloatArray.checkArray(fArray, 2)) {
            return;
        }
        if (fArray2 == null) {
            fArray2 = new float[fArray.length][2];
        } else if (!FloatArray.checkArray(fArray2, 2) || fArray2.length != fArray.length) {
            return;
        }
        if (FloatArray.equals(this.vertex, fArray) && FloatArray.equals(this.tangent, fArray2)) {
            return;
        }
        this.vertex = FloatArray.deepclone(fArray);
        this.tangent = FloatArray.deepclone(fArray2);
        this.makePath();
        this.firePropertyChange(SET_VERTEX_TANGENT_DATA, null, null);
    }

    public final void setVertex(int n, float f, float f2) {
        if (n < 0 || n >= this.vertex.length) {
            return;
        }
        if (this.vertex[n][0] == f && this.vertex[n][1] == f2) {
            return;
        }
        this.vertex[n][0] = f;
        this.vertex[n][1] = f2;
        this.makePath();
        this.firePropertyChange(SET_VERTEX, null, null);
    }

    public final void setVertex(int n, float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        this.setVertex(n, fArray[0], fArray[1]);
    }

    public final void setTangent(int n, float f, float f2) {
        if (n < 0 || n >= this.tangent.length) {
            return;
        }
        if (this.tangent[n][0] == f && this.tangent[n][1] == f2) {
            return;
        }
        this.tangent[n][0] = f;
        this.tangent[n][1] = f2;
        this.makePath();
        this.firePropertyChange(SET_TANGENT, null, null);
    }

    public final void setTangent(int n, float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        this.setTangent(n, fArray[0], fArray[1]);
    }

    public final void setVertexTangent(int n, float f, float f2, float f3, float f4) {
        if (n < 0 || n >= this.vertex.length) {
            return;
        }
        if (this.vertex[n][0] == f && this.vertex[n][1] == f2 && this.tangent[n][0] == f3 && this.tangent[n][1] == f4) {
            return;
        }
        this.vertex[n][0] = f;
        this.vertex[n][1] = f2;
        this.tangent[n][0] = f3;
        this.tangent[n][1] = f4;
        this.makePath();
        this.firePropertyChange(SET_VERTEX_TANGENT, null, null);
    }

    public final void setVertexTangent(int n, float[] fArray) {
        if (fArray == null || fArray.length != 4) {
            return;
        }
        this.setVertexTangent(n, fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public final void addVertexTangent(int n, float f, float f2, float f3, float f4) {
        int n2 = this.vertex.length;
        int n3 = n2 + 1;
        if (n < 0 || n > n2) {
            return;
        }
        float[][] fArray = this.vertex;
        float[][] fArray2 = this.tangent;
        this.vertex = new float[n3][2];
        this.tangent = new float[n3][2];
        this.vertex[n][0] = f;
        this.vertex[n][1] = f2;
        this.tangent[n][0] = f3;
        this.tangent[n][1] = f4;
        int n4 = 0;
        while (n4 < n3) {
            if (n4 < n) {
                this.vertex[n4][0] = fArray[n4][0];
                this.vertex[n4][1] = fArray[n4][1];
                this.tangent[n4][0] = fArray2[n4][0];
                this.tangent[n4][1] = fArray2[n4][1];
            } else if (n4 > n) {
                int n5 = n4 - 1;
                this.vertex[n4][0] = fArray[n5][0];
                this.vertex[n4][1] = fArray[n5][1];
                this.tangent[n4][0] = fArray2[n5][0];
                this.tangent[n4][1] = fArray2[n5][1];
            }
            ++n4;
        }
        this.makePath();
        this.firePropertyChange(ADD_VERTEX_TANGENT, null, null);
    }

    public final void addVertexTangent(int n, float[] fArray) {
        if (fArray == null || fArray.length != 4) {
            return;
        }
        this.addVertexTangent(n, fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public final void removeVertexTangent(int n) {
        int n2 = this.vertex.length;
        int n3 = n2 - 1;
        if (n < 0 || n >= n2) {
            return;
        }
        float[][] fArray = this.vertex;
        float[][] fArray2 = this.tangent;
        this.vertex = new float[n3][2];
        this.tangent = new float[n3][2];
        int n4 = 0;
        while (n4 < n2) {
            if (n4 < n) {
                this.vertex[n4][0] = fArray[n4][0];
                this.vertex[n4][1] = fArray[n4][1];
                this.tangent[n4][0] = fArray2[n4][0];
                this.tangent[n4][1] = fArray2[n4][1];
            } else if (n4 > n) {
                int n5 = n4 - 1;
                this.vertex[n5][0] = fArray[n4][0];
                this.vertex[n5][1] = fArray[n4][1];
                this.tangent[n5][0] = fArray2[n4][0];
                this.tangent[n5][1] = fArray2[n4][1];
            }
            ++n4;
        }
        this.makePath();
        this.firePropertyChange(REMOVE_VERTEX_TANGENT, null, null);
    }
}

