/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.JPTComponent;
import edu.neu.ccs.gui.MutatablePaintable;
import edu.neu.ccs.gui.MutatableWrapper;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.Refresh;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.SupportsPropertyChange;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;

public class PaintableTools {
    private PaintableTools() {
    }

    public static MutatablePaintable wrapPaintable(Paintable paintable) {
        if (paintable instanceof MutatablePaintable) {
            return (MutatablePaintable)paintable;
        }
        return new MutatableWrapper(paintable);
    }

    public static Icon makeIcon(Paintable paintable) {
        if (paintable == null) {
            return null;
        }
        return new 1(paintable);
    }

    public static BufferedImage makeBufferedImage(Paintable paintable) {
        if (paintable == null) {
            return null;
        }
        Rectangle2D rectangle2D = paintable.getBounds2D();
        int n = (int)rectangle2D.getX();
        int n2 = (int)rectangle2D.getY();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.translate(-n, -n2);
        paintable.paint(graphics2D);
        return bufferedImage;
    }

    public static TexturePaint makeTexturePaint(Paintable paintable) {
        if (paintable == null) {
            return null;
        }
        return new TexturePaint(PaintableTools.makeBufferedImage(paintable), paintable.getBounds2D());
    }

    public static JButton makeButton(Paintable paintable) {
        return PaintableTools.makeButton(paintable, null, null, null);
    }

    public static JButton makeButton(Paintable paintable, Action action) {
        return PaintableTools.makeButton(paintable, action, null, null);
    }

    public static JButton makeButton(Paintable paintable, Action action, Color color) {
        return PaintableTools.makeButton(paintable, action, color, null);
    }

    public static JButton makeButton(Paintable paintable, Action action, Color color, Insets insets) {
        if (paintable == null) {
            return null;
        }
        return new 2(action, color, insets, paintable, PaintableTools.makeIcon(paintable));
    }

    public static JPTComponent makeComponent(Paintable paintable) {
        return PaintableTools.makeComponent(paintable, null, false);
    }

    public static JPTComponent makeComponent(Paintable paintable, Color color) {
        return PaintableTools.makeComponent(paintable, color, false);
    }

    public static JPTComponent makeComponent(Paintable paintable, Color color, boolean bl) {
        if (paintable == null) {
            return null;
        }
        return new 3(color, bl, paintable);
    }

    private static void initializeButton(JButton jButton, Paintable paintable, Action action, Color color, Insets insets) {
        if (action != null) {
            jButton.addActionListener(action);
        }
        if (color != null) {
            jButton.setBackground(color);
        }
        if (insets == null) {
            insets = new Insets(2, 2, 2, 2);
        }
        jButton.setMargin(insets);
        PaintableTools.refreshComponent(jButton, paintable);
        PaintableTools.addComponentRefreshListener(jButton, paintable);
    }

    private static void initializeComponent(JComponent jComponent, Paintable paintable, Color color, boolean bl) {
        if (color != null) {
            jComponent.setBackground(color);
        }
        jComponent.setOpaque(bl);
        PaintableTools.refreshComponent(jComponent, paintable);
        PaintableTools.addComponentRefreshListener(jComponent, paintable);
    }

    private static void refreshComponent(JComponent jComponent, Paintable paintable) {
        PaintableTools.setSize(jComponent);
        PaintableTools.setLocation(jComponent, paintable);
        Refresh.packParentWindow(jComponent);
    }

    private static void addComponentRefreshListener(JComponent jComponent, Paintable paintable) {
        Object object;
        4 var2_2 = new 4(jComponent, paintable);
        jComponent.addPropertyChangeListener(var2_2);
        if (jComponent instanceof AbstractButton) {
            object = (AbstractButton)jComponent;
            ((AbstractButton)object).addActionListener(var2_2);
            ((AbstractButton)object).addChangeListener(var2_2);
        }
        if (paintable instanceof SupportsPropertyChange) {
            object = (SupportsPropertyChange)((Object)paintable);
            object.addPropertyChangeListener(var2_2);
        }
    }

    private static void setSize(JComponent jComponent) {
        jComponent.setSize(jComponent.getPreferredSize());
    }

    private static Point getLocation(JComponent jComponent, Paintable paintable) {
        Rectangle2D rectangle2D = paintable.getBounds2D();
        int n = (int)rectangle2D.getMinX();
        int n2 = (int)rectangle2D.getMinY();
        Insets insets = jComponent.getInsets();
        if (insets != null) {
            n -= insets.left;
            n2 -= insets.top;
        }
        return new Point(n, n2);
    }

    private static Rectangle2D getBounds2D(JComponent jComponent, Paintable paintable) {
        Rectangle2D rectangle2D = paintable.getBounds2D();
        int n = (int)rectangle2D.getMinX();
        int n2 = (int)rectangle2D.getMinY();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        Insets insets = jComponent.getInsets();
        if (insets != null) {
            n -= insets.left;
            n2 -= insets.top;
            n3 += insets.left + insets.right;
            n4 += insets.top + insets.bottom;
        }
        rectangle2D.setRect(n, n2, n3, n4);
        return rectangle2D;
    }

    private static void setLocation(JComponent jComponent, Paintable paintable) {
        jComponent.setLocation(PaintableTools.getLocation(jComponent, paintable));
    }

    private static final class 1
    implements Icon {
        private final /* synthetic */ Paintable val$paintable;

        public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Rectangle2D rectangle2D = this.val$paintable.getBounds2D();
            int n3 = n - (int)rectangle2D.getMinX();
            int n4 = n2 - (int)rectangle2D.getMinY();
            Graphics graphics2 = graphics.create();
            Graphics2D graphics2D = (Graphics2D)graphics2;
            graphics2D.translate(n3, n4);
            this.val$paintable.paint(graphics2);
        }

        public final int getIconWidth() {
            return (int)this.val$paintable.getBounds2D().getWidth();
        }

        public final int getIconHeight() {
            return (int)this.val$paintable.getBounds2D().getHeight();
        }

        /* synthetic */ 1(Paintable paintable) {
            this.val$paintable = paintable;
        }
    }

    private final class 2
    extends JButton {
        /* synthetic */ 2(Action action, Color color, Insets insets, Paintable paintable, Icon icon) {
            super(icon);
            PaintableTools.initializeButton(this, paintable, action, color, insets);
        }
    }

    private final class 3
    extends JPTComponent {
        private final /* synthetic */ Paintable val$paintable;

        protected void paintComponent(Graphics graphics) {
            Color color;
            Graphics graphics2 = graphics.create();
            Graphics2D graphics2D = (Graphics2D)graphics2;
            super.paintComponent(graphics2);
            Rectangle2D rectangle2D = PaintableTools.getBounds2D(this, this.val$paintable);
            graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
            if (this.isOpaque() && (color = this.getBackground()) != null) {
                Paint paint = graphics2D.getPaint();
                graphics2D.setPaint(color);
                graphics2D.fill(rectangle2D);
                graphics2D.setPaint(paint);
            }
            this.val$paintable.paint(graphics2);
        }

        public Dimension getPreferredSize() {
            Rectangle2D rectangle2D = this.val$paintable.getBounds2D();
            int n = (int)rectangle2D.getWidth();
            int n2 = (int)rectangle2D.getHeight();
            Insets insets = this.getInsets();
            if (insets == null) {
                return new Dimension(n, n2);
            }
            return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getSize() {
            return this.getPreferredSize();
        }

        /* synthetic */ 3(Color color, boolean bl, Paintable paintable) {
            this.val$paintable = paintable;
            PaintableTools.initializeComponent(this, paintable, color, bl);
        }
    }

    private static final class 4
    extends SimpleAction {
        private final /* synthetic */ Paintable val$paintable;
        private final /* synthetic */ JComponent val$component;

        public void perform() {
            PaintableTools.refreshComponent(this.val$component, this.val$paintable);
        }

        /* synthetic */ 4(JComponent jComponent, Paintable paintable) {
            this.val$component = jComponent;
            this.val$paintable = paintable;
        }
    }
}

