/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImagePaintable
extends AbstractPaintable {
    public static final String SET_IMAGE = "set.image";
    public static final String SET_TOP_LEFT_CORNER = "set.top.left.corner";
    private Image image = null;
    private Point2D corner = new Point2D.Double();

    public ImagePaintable() {
    }

    public ImagePaintable(Image image) {
        this.setImage(image);
    }

    public ImagePaintable(Image image, Point2D point2D) {
        this.setImage(image);
        this.setTopLeftCorner(point2D);
    }

    public ImagePaintable(Image image, double d, double d2) {
        this.setImage(image);
        this.setTopLeftCorner(d, d2);
    }

    public ImagePaintable(ImageIcon imageIcon) {
        this.setImageByImageIcon(imageIcon);
    }

    public ImagePaintable(ImageIcon imageIcon, Point2D point2D) {
        this.setImageByImageIcon(imageIcon);
        this.setTopLeftCorner(point2D);
    }

    public ImagePaintable(ImageIcon imageIcon, double d, double d2) {
        this.setImageByImageIcon(imageIcon);
        this.setTopLeftCorner(d, d2);
    }

    public ImagePaintable(String string) {
        this.setImageByFileName(string);
    }

    public ImagePaintable(String string, Point2D point2D) {
        this.setImageByFileName(string);
        this.setTopLeftCorner(point2D);
    }

    public ImagePaintable(String string, double d, double d2) {
        this.setImageByFileName(string);
        this.setTopLeftCorner(d, d2);
    }

    public ImagePaintable(URL uRL) {
        this.setImageByURL(uRL);
    }

    public ImagePaintable(URL uRL, Point2D point2D) {
        this.setImageByURL(uRL);
        this.setTopLeftCorner(point2D);
    }

    public ImagePaintable(URL uRL, double d, double d2) {
        this.setImageByURL(uRL);
        this.setTopLeftCorner(d, d2);
    }

    public final void paint(Graphics graphics) {
        if (this.image == null || graphics == null || !this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = this.getPreparedGraphics2D(graphics);
        AffineTransform affineTransform = TransformFactory.translate(this.corner.getX(), this.corner.getY());
        graphics2D.drawImage(this.image, affineTransform, null);
    }

    public final Rectangle2D getBounds2D() {
        if (this.image == null) {
            return new Rectangle2D.Double(this.corner.getX(), this.corner.getY(), 0.0, 0.0);
        }
        Rectangle2D rectangle2D = this.getDefaultBounds2D();
        if (rectangle2D != null) {
            return rectangle2D;
        }
        return new Rectangle2D.Double(this.corner.getX(), this.corner.getY(), this.getImageWidth(), this.getImageHeight());
    }

    public Point2D getCenter() {
        if (this.image == null) {
            return new Point2D.Double();
        }
        Point2D point2D = this.getDefaultCenter();
        if (point2D != null) {
            return point2D;
        }
        return super.getCenter();
    }

    public final boolean contains(double d, double d2) {
        return this.possiblyContains(d, d2);
    }

    public final void setImage(Image image) {
        if (image == this.image) {
            return;
        }
        this.removeAndAddForwardingListener(this.image, image);
        this.image = image;
        this.firePropertyChange(SET_IMAGE, null, null);
    }

    public final void setImageByImageIcon(ImageIcon imageIcon) {
        if (imageIcon == null) {
            return;
        }
        this.setImage(imageIcon.getImage());
    }

    public final void setImageByFileName(String string) {
        if (string == null) {
            return;
        }
        this.setImageByImageIcon(new ImageIcon(string));
    }

    public final void setImageByURL(URL uRL) {
        if (uRL == null) {
            return;
        }
        this.setImageByImageIcon(new ImageIcon(uRL));
    }

    public final Image getImage() {
        return this.image;
    }

    public final void setTopLeftCorner(Point2D point2D) {
        if (point2D == null) {
            return;
        }
        this.setTopLeftCorner(point2D.getX(), point2D.getY());
    }

    public final void setTopLeftCorner(double d, double d2) {
        this.corner = new Point2D.Double(d, d2);
        this.firePropertyChange(SET_TOP_LEFT_CORNER, null, null);
    }

    public final Point2D getTopLeftCorner() {
        return (Point2D)this.corner.clone();
    }

    public final int getImageWidth() {
        if (this.image == null) {
            return 0;
        }
        return this.image.getWidth(new JPanel());
    }

    public final int getImageHeight() {
        if (this.image == null) {
            return 0;
        }
        return this.image.getHeight(new JPanel());
    }
}

