/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.gui.ActionsPanel;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.DialogAction;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.WindowActionAdapter;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class GeneralDialog
extends JDialog
implements JPTConstants,
ConsoleAware {
    public static final String WINDOW_CLOSED = "Window Closed";
    protected Component component = null;
    protected ActionsPanel actionsPanel = new ActionsPanel();
    protected DialogAction windowClosingAction = null;
    protected Action windowOpenedAction = null;
    protected WindowActionAdapter windowActionAdapter = null;
    protected Frame parentFrame = null;
    protected Dialog parentDialog = null;
    protected String response = "";
    protected boolean cancelled = false;

    public GeneralDialog(Object object) {
        this(object, "", (Object[][])null, true, (Frame)null);
    }

    public GeneralDialog(Object object, String string) {
        this(object, string, (Object[][])null, true, (Frame)null);
    }

    public GeneralDialog(Object object, String string, Object[][] objectArray) {
        this(object, string, objectArray, true, (Frame)null);
    }

    public GeneralDialog(Object object, String string, Object[][] objectArray, boolean bl) {
        this(object, string, objectArray, bl, (Frame)null);
    }

    public GeneralDialog(Object object, String string, Object[][] objectArray, boolean bl, Frame frame) {
        super(frame, string, bl);
        this.parentFrame = frame;
        this.initialize(object, objectArray);
    }

    public GeneralDialog(Object object, String string, Object[][] objectArray, boolean bl, Dialog dialog) {
        super(dialog, string, bl);
        this.parentDialog = dialog;
        this.initialize(object, objectArray);
    }

    public void setVisible(boolean bl) {
        if (this.isVisible() == bl) {
            return;
        }
        if (bl) {
            this.pack();
            this.center();
            super.setVisible(true);
        } else {
            super.setVisible(false);
            this.dispose();
        }
    }

    public void center() {
        Cloneable cloneable;
        int n = 0;
        int n2 = 0;
        if (this.parentFrame != null) {
            cloneable = this.parentFrame.getBounds();
            n = cloneable.x + cloneable.width / 2;
            n2 = cloneable.y + cloneable.height / 2;
        } else if (this.parentDialog != null) {
            cloneable = this.parentDialog.getBounds();
            n = cloneable.x + cloneable.width / 2;
            n2 = cloneable.y + cloneable.height / 2;
        } else {
            cloneable = Toolkit.getDefaultToolkit().getScreenSize();
            n = ((Dimension)cloneable).width / 2;
            n2 = ((Dimension)cloneable).height / 2;
        }
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        ((Component)this).setLocation(n - n3 / 2, n2 - n4 / 2);
    }

    public Component getDialogContents() {
        return this.component;
    }

    public ActionsPanel getDialogActionsPanel() {
        return this.actionsPanel;
    }

    public Action[] getActions() {
        return this.getDialogActionsPanel().getActions();
    }

    public DialogAction[] getDialogActions() {
        Action[] actionArray = this.getActions();
        int n = actionArray.length;
        DialogAction[] dialogActionArray = new DialogAction[n];
        int n2 = 0;
        while (n2 < n) {
            if (actionArray[n2] instanceof DialogAction) {
                dialogActionArray[n2] = (DialogAction)actionArray[n2];
            }
            ++n2;
        }
        return dialogActionArray;
    }

    public JButton addAction(DialogAction dialogAction) {
        return this.getDialogActionsPanel().addAction(dialogAction);
    }

    public JButton addAction(Action action, Object object) {
        return this.addAction(new DialogAction(this, action, object));
    }

    public JButton addAction(String string, Object object) {
        return this.addAction(new DialogAction(this, string, object));
    }

    public JButton addAction(String string, Icon icon, Object object) {
        return this.addAction(new DialogAction(this, string, icon, object));
    }

    public void setDefaultButton(JButton jButton) {
        this.getDialogActionsPanel().setDefaultButton(jButton);
    }

    public void setDefaultButton(Action action) {
        this.getDialogActionsPanel().setDefaultButton(action);
    }

    public void setDefaultButton(String string) {
        this.getDialogActionsPanel().setDefaultButton(string);
    }

    public Action getWindowOpenedAction() {
        return this.windowOpenedAction;
    }

    public void setWindowOpenedAction(Action action) {
        if (this.windowOpenedAction != null) {
            this.windowActionAdapter.removeWindowOpenedAction(this.windowOpenedAction);
        }
        this.windowOpenedAction = action;
        if (this.windowOpenedAction != null) {
            this.windowActionAdapter.addWindowOpenedAction(this.windowOpenedAction);
        }
    }

    public DialogAction getWindowClosingAction() {
        return this.windowClosingAction;
    }

    public DialogAction getDefaultWindowClosingAction() {
        return new DialogAction(this, WINDOW_CLOSED, DialogAction.AUTO_CLOSE);
    }

    public void setWindowClosingAction(DialogAction dialogAction) {
        if (this.windowClosingAction != null) {
            this.windowActionAdapter.removeWindowClosingAction(this.windowClosingAction);
        }
        this.windowClosingAction = dialogAction != null ? dialogAction : this.getDefaultWindowClosingAction();
        this.windowActionAdapter.addWindowClosingAction(this.windowClosingAction);
    }

    public void setWindowClosingAction(Action action, Object object) {
        this.setWindowClosingAction(new DialogAction(this, action, object));
    }

    public void setWindowClosingAction(String string, Object object) {
        this.setWindowClosingAction(new DialogAction(this, string, object));
    }

    public WindowActionAdapter getWindowActionAdapter() {
        return this.windowActionAdapter;
    }

    public String getResponse() {
        return this.response;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public static GeneralDialog makeOneButtonDialog(Object object, String string, Action action) {
        GeneralDialog generalDialog = new GeneralDialog(object, string, new Object[][]{{action}});
        generalDialog.setWindowClosingAction(action, DialogAction.AUTO_CLOSE);
        generalDialog.setDefaultButton(action);
        return generalDialog;
    }

    public static String showOneButtonDialog(Object object, String string, Action action) {
        GeneralDialog generalDialog = GeneralDialog.makeOneButtonDialog(object, string, action);
        generalDialog.setVisible(true);
        return generalDialog.getResponse();
    }

    public static GeneralDialog makeOneButtonDialog(Object object, String string, String string2) {
        return GeneralDialog.makeOneButtonDialog(object, string, DialogAction.makeTrivialAction(string2));
    }

    public static String showOneButtonDialog(Object object, String string, String string2) {
        GeneralDialog generalDialog = GeneralDialog.makeOneButtonDialog(object, string, string2);
        generalDialog.setVisible(true);
        return generalDialog.getResponse();
    }

    public static GeneralDialog makeOneButtonDialog(Object object, String string, String string2, Icon icon) {
        return GeneralDialog.makeOneButtonDialog(object, string, DialogAction.makeTrivialAction(string2, icon));
    }

    public static String showOneButtonDialog(Object object, String string, String string2, Icon icon) {
        GeneralDialog generalDialog = GeneralDialog.makeOneButtonDialog(object, string, string2, icon);
        generalDialog.setVisible(true);
        return generalDialog.getResponse();
    }

    public static GeneralDialog makeOKDialog(Object object, String string) {
        return GeneralDialog.makeOneButtonDialog(object, string, "OK");
    }

    public static String showOKDialog(Object object, String string) {
        GeneralDialog generalDialog = GeneralDialog.makeOKDialog(object, string);
        generalDialog.setVisible(true);
        return generalDialog.getResponse();
    }

    public static GeneralDialog makeOKCancelDialog(Object object, String string) {
        Action action = DialogAction.makeTrivialAction("OK");
        Action action2 = DialogAction.makeTrivialAction("Cancel");
        Object[][] objectArray = new Object[][]{{action}, {action2, DialogAction.SET_CANCEL}};
        GeneralDialog generalDialog = new GeneralDialog(object, string, objectArray);
        generalDialog.setWindowClosingAction(action2, DialogAction.SET_CANCEL);
        generalDialog.setDefaultButton(action);
        return generalDialog;
    }

    public static String showOKCancelDialog(Object object, String string) throws CancelledException {
        GeneralDialog generalDialog = GeneralDialog.makeOKCancelDialog(object, string);
        generalDialog.setVisible(true);
        if (generalDialog.wasCancelled()) {
            throw new CancelledException();
        }
        return generalDialog.getResponse();
    }

    public static GeneralDialog makeYesNoCancelDialog(Object object, String string) {
        Action action = DialogAction.makeTrivialAction("Yes");
        Action action2 = DialogAction.makeTrivialAction("No");
        Action action3 = DialogAction.makeTrivialAction("Cancel");
        Object[][] objectArray = new Object[][]{{action}, {action2}, {action3, DialogAction.SET_CANCEL}};
        GeneralDialog generalDialog = new GeneralDialog(object, string, objectArray);
        generalDialog.setWindowClosingAction(action3, DialogAction.SET_CANCEL);
        generalDialog.setDefaultButton(action);
        return generalDialog;
    }

    public static String showYesNoCancelDialog(Object object, String string) throws CancelledException {
        GeneralDialog generalDialog = GeneralDialog.makeYesNoCancelDialog(object, string);
        generalDialog.setVisible(true);
        if (generalDialog.wasCancelled()) {
            throw new CancelledException();
        }
        return generalDialog.getResponse();
    }

    protected void initialize(Object object, Object[][] objectArray) {
        this.component = this.makeComponent(object);
        if (this.component == null) {
            this.component = new JPanel();
        }
        this.actionsPanel.addActions(DialogAction.makeDialogActions(this, objectArray));
        this.createContentPane();
        this.installWindowActionAdapter();
    }

    protected Component makeComponent(Object object) {
        return ComponentFactory.makeComponent(object);
    }

    protected void createContentPane() {
        TablePanel tablePanel = new TablePanel(2, 1, 5, 5, 1);
        tablePanel.add(this.component);
        tablePanel.add(this.actionsPanel);
        JPanel jPanel = new JPanel(new CenterLayout());
        jPanel.add(tablePanel);
        this.setContentPane(jPanel);
    }

    protected void installWindowActionAdapter() {
        this.setDefaultCloseOperation(0);
        this.windowActionAdapter = new WindowActionAdapter(this);
        this.setWindowClosingAction(null);
    }

    protected void setResponseAndClose(String string) {
        this.response = string != null ? string : "";
        this.closeDialog();
    }

    protected void closeDialog() {
        this.setVisible(false);
    }

    protected void setCancelled(boolean bl) {
        this.cancelled = bl;
    }
}

