/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XObject;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.StringableFilter;
import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.InputDialog;
import edu.neu.ccs.gui.TypedView;
import java.awt.Component;
import java.awt.Font;
import java.text.ParseException;

public class ErrorDialog
extends InputDialog {
    protected Annotation errorMessage = null;
    protected String originalValue = null;
    protected StringableFilter filter = null;

    public ErrorDialog(Stringable stringable, TypedView typedView, StringableFilter stringableFilter, ParseException parseException) {
        super(typedView);
        if (stringable == null || typedView == null || parseException == null) {
            throw new NullPointerException("Null parameter in constructor.");
        }
        this.model = stringable;
        this.filter = stringableFilter;
        this.originalValue = this.view.getViewState();
        this.errorMessage = new Annotation(XObject.formatErrorMessage(parseException, this.view.getViewState()));
        this.errorMessage.setFont(new Font("monospaced", 0, 12));
        this.getContentPane().add((Component)this.errorMessage, "North");
        this.pack();
        this.center();
    }

    protected void ok() {
        try {
            block6: {
                try {
                    this.model.fromStringData(this.view.getViewState());
                    if (this.filter == null) break block6;
                    try {
                        this.model = this.filter.filterStringable(this.model);
                    }
                    catch (FilterException filterException) {
                        throw new ParseException(filterException.getMessage(), -1);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(numberFormatException.getMessage(), -1);
                }
            }
            ((Component)this).setVisible(false);
            this.dispose();
        }
        catch (ParseException parseException) {
            this.errorMessage.setText(XObject.formatErrorMessage(parseException, this.view.getViewState()));
            this.pack();
            this.center();
        }
    }

    protected void reset() {
        this.view.setViewState(this.originalValue);
    }

    protected void cancel() {
        this.reset();
        super.cancel();
    }
}

