/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.filter.StringableFilter;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.Fragile;
import edu.neu.ccs.gui.GeneralView;
import edu.neu.ccs.gui.GeneralViewSupport;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JComboBox;

public class DropdownView
extends JComboBox
implements GeneralView,
Fragile,
JPTConstants {
    public static final int DEFAULT_WIDTH = 200;
    protected static final String DEFAULT_SELECTION = "";
    protected GeneralViewSupport delegate = null;
    protected Vector itemList = new Vector();

    public DropdownView() {
        this(null, DEFAULT_SELECTION, 0, false, null, null);
    }

    public DropdownView(Object[] objectArray) {
        this(objectArray, DEFAULT_SELECTION, 0, false, null, null);
    }

    public DropdownView(Object[] objectArray, String string) {
        this(objectArray, string, 0, false, null, null);
    }

    public DropdownView(Object[] objectArray, String string, int n) {
        this(objectArray, string, n, false, null, null);
    }

    public DropdownView(Object[] objectArray, String string, int n, boolean bl) {
        this(objectArray, string, n, bl, null, null);
    }

    public DropdownView(Object[] objectArray, String string, int n, boolean bl, Class clazz) {
        this(objectArray, string, n, bl, clazz, null);
    }

    public DropdownView(Object[] objectArray, String string, int n, boolean bl, Class clazz, StringableFilter stringableFilter) {
        this.delegate = new GeneralViewSupport(this, this.listenerList, null, null, null, null);
        this.setEditable(bl);
        this.addItems(objectArray);
        this.setPreferredWidth(n);
        this.setViewState(string);
        this.setDefaultViewState(string);
        this.setDataType(clazz);
        this.setFilter(stringableFilter);
    }

    public void addItem(Object object) {
        if (object == null) {
            return;
        }
        this.itemList.add(object);
        super.addItem(object);
    }

    public void insertItemAt(Object object, int n) {
        this.itemList.add(n, object);
        super.insertItemAt(object, n);
    }

    public void removeItem(Object object) {
        if (object == null) {
            return;
        }
        this.itemList.remove(object);
        super.removeItem(object);
    }

    public void removeItemAt(int n) {
        this.itemList.remove(n);
        super.removeItemAt(n);
    }

    public void removeAllItems() {
        this.itemList.clear();
        super.removeAllItems();
    }

    public void addItems(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                this.addItem(objectArray[n]);
            }
            ++n;
        }
    }

    public void setItems(Object[] objectArray) {
        this.removeAllItems();
        this.addItems(objectArray);
    }

    public void removeItems(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                this.removeItem(objectArray[n]);
            }
            ++n;
        }
    }

    public Object[] getItems() {
        return this.itemList.toArray();
    }

    public void setPreferredWidth(int n) {
        if (n < 0) {
            return;
        }
        if (n == 0) {
            n = 200;
        }
        this.setPreferredSize(new Dimension(n, this.getPreferredSize().height));
    }

    public GeneralView makeCopy() {
        DropdownView dropdownView = new DropdownView();
        dropdownView.addItems(this.getItems());
        dropdownView.setPreferredSize(this.getPreferredSize());
        dropdownView.setEditable(this.isEditable());
        dropdownView.setDataType(this.getDataType());
        dropdownView.setViewState(this.getViewState());
        dropdownView.setDefaultViewState(this.getDefaultViewState());
        dropdownView.setInputProperties(new InputProperties(this.getInputProperties()));
        dropdownView.setFilter(this.getFilter());
        return dropdownView;
    }

    public void setDataType(Class clazz) {
        this.delegate.setDataType(clazz);
    }

    public Class getDataType() {
        return this.delegate.getDataType();
    }

    public void setFilter(StringableFilter stringableFilter) {
        this.delegate.setFilter(stringableFilter);
    }

    public StringableFilter getFilter() {
        return this.delegate.getFilter();
    }

    public Stringable demandObject() {
        return this.delegate.demandObject();
    }

    public Stringable requestObject() throws CancelledException {
        return this.delegate.requestObject();
    }

    public Stringable demandObject(StringableFilter stringableFilter) {
        return this.delegate.demandObject(stringableFilter);
    }

    public Stringable requestObject(StringableFilter stringableFilter) throws CancelledException {
        return this.delegate.requestObject(stringableFilter);
    }

    public Stringable demandObject(Class clazz, StringableFilter stringableFilter) {
        return this.delegate.demandObject(clazz, stringableFilter);
    }

    public Stringable requestObject(Class clazz, StringableFilter stringableFilter) throws CancelledException {
        return this.delegate.requestObject(clazz, stringableFilter);
    }

    public void setInputProperties(InputProperties inputProperties) {
        this.delegate.setInputProperties(inputProperties);
    }

    public InputProperties getInputProperties() {
        return this.delegate.getInputProperties();
    }

    public void setErrorPromptTitleSuggestion(String string, String string2, String string3) {
        this.delegate.setErrorPromptTitleSuggestion(string, string2, string3);
    }

    public void setViewState(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getViewState();
        if (string.equals(string2)) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.getItemCount()) {
            String string3 = this.getItemAt(n).toString();
            if (string3 != null && string3.equals(string)) {
                this.setSelectedIndex(n);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl && this.isEditable()) {
            this.setSelectedItem(string);
            bl = true;
        }
        if (bl) {
            this.firePropertyChange("view.state", string2, string);
        }
    }

    public String getViewState() {
        return (String)this.getSelectedItem();
    }

    public void setDefaultViewState(String string) {
        this.delegate.setDefaultViewState(string);
    }

    public String getDefaultViewState() {
        return this.delegate.getDefaultViewState();
    }

    public void reset() {
        this.delegate.reset();
    }

    public void addMalformedDataListener(MalformedDataListener malformedDataListener) {
        this.delegate.addMalformedDataListener(malformedDataListener);
    }

    public void removeMalformedDataListener(MalformedDataListener malformedDataListener) {
        this.delegate.removeMalformedDataListener(malformedDataListener);
    }
}

