/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.ColorNames;
import edu.neu.ccs.Stringable;
import edu.neu.ccs.XColor;
import edu.neu.ccs.gui.ActionSequence;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.DropdownView;
import edu.neu.ccs.gui.Halo;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.JPTComponent;
import edu.neu.ccs.gui.MouseAction;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TableLayout;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;

public class ColorView
extends DisplayPanel
implements TypedView,
JPTConstants {
    public static final String CHOOSER_CLICK_COUNT = "chooser click count";
    public static final String SET_CURRENT_COLOR = "set current color";
    public static final String SET_DEFAULT_COLOR = "set default color";
    public static final Color DEFAULT_COLOR = Color.black;
    public static final int DEFAULT_CHOOSER_CLICK_COUNT = 2;
    public static final int BOX_SIZE = 20;
    public static final Dimension DEFAULT_DIMENSION = new Dimension(20, 20);
    public static final int DEFAULT_WIDTH = 200;
    private Color currentColor = DEFAULT_COLOR;
    private Color defaultColor = DEFAULT_COLOR;
    private int chooserClickCount = 2;
    private JPTComponent colorBox = new 1();
    private MouseActionAdapter colorBoxActions = this.colorBox.getMouseActionAdapter();
    private MouseAction colorBoxAction = new 2();
    private DropdownView colorDropdownView = new DropdownView(ColorNames.getColorNamesAsArray(), "", 200, true, class$edu$neu$ccs$XColor != null ? class$edu$neu$ccs$XColor : (class$edu$neu$ccs$XColor = ColorView.class$("edu.neu.ccs.XColor")));
    private Action setColorFromDropdownView = new 3("Set Color From Drop Down View");
    private ActionSequence setColorActions = new ActionSequence();
    static /* synthetic */ Class class$edu$neu$ccs$XColor;

    public ColorView() {
        this(null, false, null, 0);
    }

    public ColorView(Color color) {
        this(color, false, null, 0);
    }

    public ColorView(Color color, boolean bl) {
        this(color, bl, null, 0);
    }

    public ColorView(Color color, boolean bl, Dimension dimension) {
        this(color, bl, dimension, 0);
    }

    public ColorView(Color color, boolean bl, Dimension dimension, int n) {
        this.setLayout(new TableLayout(1, 2, 5, 5, 0));
        this.installColorBox(color, dimension);
        this.installColorDropdownView(bl, n);
        this.installColorBoxActions();
        this.reset();
    }

    public ColorView(Color color, boolean bl, int n, int n2) {
        this(color, bl, new Dimension(n, n2), 0);
    }

    public ColorView(Color color, boolean bl, int n, int n2, int n3) {
        this(color, bl, new Dimension(n, n2), n3);
    }

    public JPTComponent getColorBox() {
        return this.colorBox;
    }

    public DropdownView getColorDropdownView() {
        return this.colorDropdownView;
    }

    public void setColor(Color color) {
        if (color == null || color.equals(this.currentColor)) {
            return;
        }
        Color color2 = this.currentColor;
        this.currentColor = color;
        this.colorBox.repaint();
        this.colorDropdownView.setViewState(this.getViewState());
        this.setColorActions.actionPerformed(new ActionEvent(this, 1001, SET_CURRENT_COLOR));
        this.firePropertyChange(SET_CURRENT_COLOR, color2, color);
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setDefaultColor(Color color) {
        if (color == null || color.equals(this.defaultColor)) {
            return;
        }
        Color color2 = this.defaultColor;
        this.defaultColor = color;
        this.colorDropdownView.setDefaultViewState(this.getDefaultViewState());
        this.firePropertyChange(SET_DEFAULT_COLOR, color2, color);
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public ActionSequence getSetColorActions() {
        return this.setColorActions;
    }

    public void addAction(Action action) {
        this.setColorActions.add(action);
    }

    public void addAction(int n, Action action) {
        this.setColorActions.add(n, action);
    }

    public boolean removeAction(Action action) {
        return this.setColorActions.remove(action);
    }

    public Action removeAction(int n) {
        return this.setColorActions.remove(n);
    }

    public MouseActionAdapter getMouseActionAdapter() {
        return this.colorBoxActions;
    }

    public void setChooserClickCount(int n) {
        int n2 = this.chooserClickCount;
        this.chooserClickCount = n <= 1 ? 1 : 2;
        this.firePropertyChange(CHOOSER_CLICK_COUNT, n2, this.chooserClickCount);
    }

    public int getChooserClickCount() {
        return this.chooserClickCount;
    }

    public Stringable demandObject() {
        return new XColor(this.getColor());
    }

    public Stringable requestObject() {
        return this.demandObject();
    }

    public void setInputProperties(InputProperties inputProperties) {
        InputProperties inputProperties2 = this.getInputProperties();
        this.getColorDropdownView().setInputProperties(inputProperties);
        InputProperties inputProperties3 = this.getInputProperties();
        this.firePropertyChange("input.properties", inputProperties2, inputProperties3);
    }

    public InputProperties getInputProperties() {
        return this.getColorDropdownView().getInputProperties();
    }

    public Class getDataType() {
        return class$edu$neu$ccs$XColor != null ? class$edu$neu$ccs$XColor : (class$edu$neu$ccs$XColor = ColorView.class$("edu.neu.ccs.XColor"));
    }

    public void setViewState(String string) {
        try {
            XColor xColor = new XColor(string);
            this.setColor(xColor.getValue());
        }
        catch (ParseException parseException) {}
    }

    public String getViewState() {
        return XColor.colorToString(this.getColor());
    }

    public void setDefaultViewState(String string) {
        try {
            XColor xColor = new XColor(string);
            this.setDefaultColor(xColor.getValue());
        }
        catch (ParseException parseException) {}
    }

    public String getDefaultViewState() {
        return XColor.colorToString(this.getDefaultColor());
    }

    public void reset() {
        this.setColor(this.defaultColor);
    }

    protected void setColorFromDropdownView() {
        XColor xColor = (XColor)this.colorDropdownView.demandObject();
        this.setColor(xColor.getValue());
    }

    protected void installColorBox(Color color, Dimension dimension) {
        this.currentColor = color = color == null ? DEFAULT_COLOR : color;
        this.defaultColor = color;
        dimension = dimension == null ? DEFAULT_DIMENSION : dimension;
        this.colorBox.setPreferredSize(dimension);
        this.colorBox.setBorder(new LineBorder(Color.black, 1));
        this.add(this.colorBox);
    }

    protected void installColorDropdownView(boolean bl, int n) {
        this.colorDropdownView.setViewState(this.getViewState());
        this.colorDropdownView.setDefaultViewState(this.getDefaultViewState());
        n = n <= 0 ? 200 : n;
        this.colorDropdownView.setPreferredWidth(n);
        this.colorDropdownView.setErrorPromptTitleSuggestion("Color Error", "Color Error Dialog", this.getDefaultViewState());
        this.colorDropdownView.addActionListener(this.setColorFromDropdownView);
        if (bl) {
            this.add(new Halo(this.colorDropdownView));
        }
    }

    protected void installColorBoxActions() {
        this.colorBoxActions.addMouseClickedAction(this.colorBoxAction);
    }

    private void colorBoxAction(MouseEvent mouseEvent) {
        Color color;
        if (this.colorBox.isEnabled() && mouseEvent.getClickCount() >= this.chooserClickCount && (color = JColorChooser.showDialog(new JLabel("Choose Color:"), "", this.getColor())) != null) {
            this.setColor(color);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class 1
    extends JPTComponent {
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(ColorView.this.getColor());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent mouseEvent) {
            ColorView.this.colorBoxAction(mouseEvent);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends SimpleAction {
        public void perform() {
            ColorView.this.setColorFromDropdownView();
        }

        /* synthetic */ 3(String string) {
            super(string);
        }
    }
}

